// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/exit.cc
/// @brief  Program exit functions and macros
/// @author David Kim (dekim@u.washington.edu)
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Unit headers
#include <utility/exit.hh>

// C++ headers
#include <cassert>
#include <cstdlib>
#include <iostream>

// Boinc headers
#ifdef BOINC
#include <boinc/boinc_rosetta_util.h>
#endif


namespace utility {


/// @brief Exit with file + line + message + optional status
void
exit(
	std::string const & file,
	int const line,
	std::string const & message,
	int const status
)
{
	if ( ! message.empty() ) std::cerr << message << std::endl;
	std::cerr << "ERROR:: Exit from: " << file << " line: " << line << std::endl;
#ifdef BOINC
	boinc_exit( status );
#else // Not BOINC
#ifndef _WIN32
	assert( false ); // Force a core dump for post-mortem debugging
#endif // Not _WIN32
	std::exit( status );
#endif // BOINC
}


} // namespace utility
