// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/file/gzip_util.hh
/// @brief  gzip utility functions
/// @author David Kim (dekim@u.washington.edu)


#ifndef INCLUDED_utility_file_gzip_util_HH
#define INCLUDED_utility_file_gzip_util_HH


// C++ headers
#include <string>


namespace utility {
namespace file {


/// @brief gzip: file compression
long
gzip(
	std::string const & uncompressedfile,
	bool overwrite = false
);


/// @brief gunzip: file decompression
long
gunzip(
	std::string const & compressedfile,
	bool overwrite = false
);


} // namespace file
} // namespace utility


#endif // INCLUDED_utility_file_gzip_util_HH
