// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/KeyLookup.functors.hh
/// @brief  utility::keys::KeyLookup functor declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
///
/// @note Convenience header for inclusion/injection into key collection namespaces
/// @note Must typedef the collection key type to KeyType above point of inclusion


/// @brief Lookup functors
extern utility::keys::lookup::has  < KeyType > const has  ; // Provides has( id ) and has( key )
extern utility::keys::lookup::key  < KeyType > const key  ; // Provides key( id ) and key( key )
extern utility::keys::lookup::gen  < KeyType > const gen  ; // Provides gen( id, identifier, code ) and gen( key )
extern utility::keys::lookup::n_key< KeyType > const n_key; // Provides n_key()
extern utility::keys::lookup::begin< KeyType > const begin; // Provides begin()
extern utility::keys::lookup::end  < KeyType > const end  ; // Provides end()
