// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19167 $
//  $Date: 2007-12-16 13:38:56 +0200 (Sun, 16 Dec 2007) $
//  $Author: yab $

#ifndef INCLUDED_status
#define INCLUDED_status


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <map>

// status Function Declarations

namespace score_file_ns {
	extern bool use_new_columns;
	extern std::map<std::string,float>       new_float_cols;
	extern std::map<std::string,int>         new_int_cols;
	extern std::map<std::string,std::string> new_string_cols;
}

void
save_status_info(
	std::string const & type,
	int start,
	int size
);


void
reset_status_info();


utility::io::ozstream *
initialize_status_file( bool fullatom );


void
close_status_file();


void
output_status_file(
	int monte_carlo_accept,
	float temperature
);


void
score_header_output(
	std::ostream & iunit,
	bool fullatom
);


void
score_output(
	std::ostream & iunit,
	std::string const & tag,
	bool fullatom
);


void
update_scorefile_info();


double
minutes();

void
save_filter_tag( std::string const & tag);

std::string
get_filter_tag();

bool
get_output_filter();

int
get_user_score_tag_length();

std::string
get_user_score_tag();

#endif
