// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8387 $
//  $Date: 2006-05-16 14:08:33 -0700 (Tue, 16 May 2006) $
//  $Author: johnk $

#ifndef INCLUDED_symmetric_design
#define INCLUDED_symmetric_design

#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Namespace
namespace design_sym {
	extern int num_clones;
	extern FArray1D_int clone_follows;
	extern FArray2D_int clone_list;
	extern FArray3D_float clone_Mgl;
}


// Symmetric design functions

void
setup_symmetric_packing( int const total_residue );


void
setup_symmetric_packing(
	int const nres,
	pose_ns::Symmetry_info const & s
);


void
reset_symmetric_packing();


void
get_sym_rotamer_transform(
	FArray2Da_float starting_full_coord,
	FArray2Da_float arrival_full_coord,
	FArray2Da_float Mgl
);


bool
verify_sym_rotamer_transform(
	FArray2Da_float incoord,
	FArray2Da_float targetcoord,
	FArray2Da_float Mgl
);


void
transfer_sym_rotamer(
  int aa,
	int aav,
	FArray2Da_float Mgl,
	FArray2Da_float incoord,
	FArray1Da_float inactcoord,
	FArray2Da_float outcoord,
	FArray1Da_float outactcoord
);

bool
identity_Mgl( FArray2Da_float Mgl );

#endif

