// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8356 $
//  $Date: 2006-05-14 05:27:20 +0300 (Sun, 14 May 2006) $
//  $Author: johnk $


// Rosetta Headers
#include "template_pack.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


//bk template variables
//bk hb_nbors      :neighbors for NH and carbonyl O on backbone
//bk neighbors     :number of neighbors
//bk neighborlist  :lists who are neighbors
//bk nhcoord       :coordinates of amide hydrogens
//bk chiarray      :chi angles
//bk rotarray      :rotamers


namespace template_pack {

	// jk If phi/psi do not exist due to chain break,
	// use these "neutral" phi/psi to compute Dunbrack
	// energy and prob of aa given phi/psi
	float const neutral_phi = { -90. };
	float const neutral_psi = { 130. };

	FArray1D_float phi( MAX_RES() );
	FArray1D_float psi( MAX_RES() );
	FArray1D_int neighbors( MAX_RES() );
	FArray2D_float chiarray( MAX_CHI, MAX_RES() );
	FArray2D_int hb_nbors( 2, MAX_RES() );
	FArray2D_int rotarray( MAX_CHI, MAX_RES() );
	FArray2D_float nhcoord( 3, MAX_RES() );
	FArray2D_float actcoord( 3, MAX_RES() );
	FArray2D_float born_radius( MAX_ATOM(), MAX_RES() );
	FArray2D_bool neighborlist( MAX_RES(), MAX_RES() );
	FArray2D_bool designed_matrix( MAX_AA(), MAX_RES() );
}
