// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 9576 $
//  $Date: 2006-08-08 18:44:37 +0300 (Tue, 08 Aug 2006) $
//  $Author: bqian $

#ifndef INCLUDED_termini
#define INCLUDED_termini


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


namespace termini_ns {

	extern FArray1D_bool is_N_terminus;
	extern FArray1D_bool is_C_terminus;

	extern bool use_N_terminus; // do we want to use the termini?
	extern bool use_C_terminus; // do we want to use the termini?
}


void
build_termini(
	bool fullatom
);


void
setup_termini(
);


void
create_termini_variants( int aa );


void
add_N_terminus_to_variant(
	int aa,
	int starting_variant
);


void
add_C_terminus_to_variant(
	int aa,
	int starting_variant
);


void
build_N_terminus_Hs(
	FArray3DB_float const & xyzposition, // see comment below
	int const aan, // amino acid type
	int const resnum,
	float const phi_first,
	FArray2DB_float & Nterm_nhcoord
);


void
build_C_terminus_Os(
	FArray3DB_float const & xyzposition, // see comment below
	int const resnum,
	float const psi_last,
	FArray2DB_float & Cterm_cocoord
);


void
make_space_in_coords(
	int const & atompos,
	int const & respos
);
#endif
