// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/AutoKey.test.cc
/// @brief  AutoKey unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Package headers
#include <utility/keys/AutoKey.hh>

// Test headers
#include <utility/keys/AutoKey.test.hh>


namespace test {
namespace utility {
namespace keys {


// --- set up some helper classes, in their own namespace

namespace autokey {

class X_
{};


class XKey_ : public ::utility::keys::AutoKey< X_ >
{

	friend class X_;

	typedef  ::utility::keys::AutoKey< X_ >  Super;


public: // Creation


	/// @brief Default constructor
	inline
	explicit
	XKey_(
		std::string const & id_a = std::string(),
		std::string const & identifier_a = std::string(),
		std::string const & code_a = std::string()
	) :
		Super( id_a, identifier_a, code_a )
	{}


	/// @brief Clone this
	inline
	XKey_ *
	clone() const
	{
		return new XKey_( *this );
	}


	/// @brief Destructor
	inline
	virtual
	~XKey_()
	{}


};

} // namespace autokey


// grant access to our helper classes
using namespace autokey;


// --- set up the test suite
TEST_SUITE_BEGIN(AutoKey_Tests)
	TEST_SUITE_USES_CASE(test_AutoKey_general)
TEST_SUITE_END


// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_AutoKey_general)
{
	// make first key
	XKey_ key1( "Key1" );
	TEST_CHECK( key1.id() == "Key1" );

	// make second key
	XKey_ key2( "Key2" );
	TEST_CHECK( key2.id() == "Key2" );

	// compare keys
	TEST_CHECK( key1 < key2 );
}
TEST_CASE_END


} // namespace keys
} // namespace utility
} // namespace test
