// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/Key4Tuple.test.cc
/// @brief  Key4Tuple unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Package headers
#include <utility/keys/Key4Tuple.test.hh>
#include <utility/keys/Key4Tuple.hh>


namespace test {
namespace utility {
namespace keys {


// --- set up the test suite
TEST_SUITE_BEGIN(Key4Tuple_Tests)
	TEST_SUITE_USES_CASE(test_Key4Tuple_general)
TEST_SUITE_END


// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_Key4Tuple_general)
{
	using namespace ::utility::keys;

	typedef  Key4Tuple< int, int, int, int >  Key4Tuple_int;
	typedef  Key4Tuple< short, int, float, double >  Key4Tuple_mix;

	{ // Constructor and accessors
		Key4Tuple_int key( 1, 2, 3, 4 );
		TEST_CHECK( key.key1() == 1 );
		TEST_CHECK( key.key2() == 2 );
		TEST_CHECK( key.key3() == 3 );
		TEST_CHECK( key.key4() == 4 );
	}

	{ // Copy constructor and comparisons
		Key4Tuple_int keyA( 1, 2, 3, 4 ), keyB( keyA );
		TEST_CHECK( keyA == keyB );
		TEST_CHECK( ! ( keyA < keyB ) );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

	{ // Default constructor, assignment, and comparisons
		Key4Tuple_int keyA( 1, 2, 3, 4 ), keyB;
		keyB = keyA;
		TEST_CHECK( keyA == keyB );
		TEST_CHECK( ! ( keyA != keyB ) );
		TEST_CHECK( ! ( keyA < keyB ) );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

	{ // Default constructor, assignment, and comparisons
		Key4Tuple_int keyA( 1, 2, 3, 4 ), keyB;
		keyB = keyA;
		TEST_CHECK( keyA == keyB );
		TEST_CHECK( ! ( keyA != keyB ) );
		TEST_CHECK( ! ( keyA < keyB ) );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

	{ // Lexicographic ordering
		Key4Tuple_int keyA( 1, 2, 3, 4 );
		Key4Tuple_int keyB( 1, 2, 4, 4 );
		TEST_CHECK( ! ( keyA == keyB ) );
		TEST_CHECK( keyA != keyB );
		TEST_CHECK( keyA < keyB );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

	{ // Lexicographic ordering
		Key4Tuple_int keyA( 1, 2, 3, 4 );
		Key4Tuple_int keyB( 2, 1, 2, 3 );
		TEST_CHECK( ! ( keyA == keyB ) );
		TEST_CHECK( keyA != keyB );
		TEST_CHECK( keyA < keyB );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

	{ // Lexicographic ordering with mixed Key types
		Key4Tuple_mix keyA( 1, 2, 3.0f, 4.0 );
		Key4Tuple_mix keyB( 2, 1, 2.0f, 3.0 );
		TEST_CHECK( ! ( keyA == keyB ) );
		TEST_CHECK( keyA != keyB );
		TEST_CHECK( keyA < keyB );
		TEST_CHECK( ! ( keyB < keyA ) );
	}

}
TEST_CASE_END


} // namespace keys
} // namespace utility
} // namespace test
