// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/UserKey.test.cc
/// @brief  UserKey unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Package headers
#include <utility/keys/UserKey.test.hh>
#include <utility/keys/UserKey.hh>


namespace test {
namespace utility {
namespace keys {


class X
{};


class XKey : public ::utility::keys::UserKey< X >
{

	friend class X;

	typedef  ::utility::keys::UserKey< X >  Super;


public: // Creation


	/// @brief Default constructor
	inline
	explicit
	XKey(
		std::string const & id_a = std::string(),
		std::string const & identifier_a = std::string(),
		std::string const & code_a = std::string()
	) :
		Super( id_a, identifier_a, code_a )
	{}


	/// @brief Index constructor
	inline
	XKey(
		Size const & index_a,
		std::string const & id_a = std::string(),
		std::string const & identifier_a = std::string(),
		std::string const & code_a = std::string()
	) :
		Super( index_a, id_a, identifier_a, code_a )
	{}


	/// @brief Clone this
	inline
	XKey *
	clone() const
	{
		return new XKey( *this );
	}


	/// @brief Destructor
	inline
	virtual
	~XKey()
	{}


};


// --- set up the test suite
TEST_SUITE_BEGIN(UserKey_Tests)
	TEST_SUITE_USES_CASE(test_UserKey_general)
TEST_SUITE_END


// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_UserKey_general)
{
	XKey::Size n_key( 0 );

	// make first key
	XKey key1( ++n_key, "Key1" );
	TEST_CHECK( key1.id() == "Key1" );

	// make second key
	XKey key2( ++n_key, "Key2" );
	TEST_CHECK( key2.id() == "Key2" );

	// compare keys
	TEST_CHECK( key1 < key2 );
}
TEST_CASE_END


} // namespace keys
} // namespace utility
} // namespace test
