// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/pointer/access_ptr.test.hh
/// @brief  access_ptr.test: test suite for utility::pointer::access_ptr
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


#ifndef INCLUDED_utility_pointer_access_ptr_test_HH
#define INCLUDED_utility_pointer_access_ptr_test_HH


// Testing headers
#include <testing/unittest/Tests.hh>
#include <testing/unittest/TestSuite.hh>
#include <testing/unittest/TestCase.hh>


namespace test {
namespace utility {
namespace pointer {


// Declare test suites
TEST_SUITE(Access_Ptr_Tests)


// Declare test cases
TEST_CASE(test_access_ptr_size)
TEST_CASE(test_access_ptr_basics)
TEST_CASE(test_access_ptr_constructor)
TEST_CASE(test_access_ptr_derived)
TEST_CASE(test_access_ptr_const_object)
TEST_CASE(test_access_ptr_derived_conversion)
TEST_CASE(test_access_ptr_derived_construction_assignment)
TEST_CASE(test_access_ptr_constant_construction_assignment)


} // namespace pointer
} // namespace utility
} // namespace test


#endif // INCLUDED_utility_pointer_access_ptr_test_HH
