// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_torsion_bbmove_trials
#define INCLUDED_torsion_bbmove_trials


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include "pose_fwd.h"


// Types
typedef  float (*Scoring_Function)();


// torsion_bbmove_trials Function Declarations


void
main_wobble_trial(
	int size,
	float cutoff_max,
	Scoring_Function score_fxn,
	int cycle_number,
	int nwobble,
	int max_wobble_gap
);


void
main_gunn_wobble_trial(
	int size,
	float cutoff_max,
	Scoring_Function score_fxn,
	int cycle_number,
	int nwobble,
	int wobble_gap
);


void
main_small_trial(
	Scoring_Function score_fxn,
	int cycle_number
);


void
main_shear_trial(
	Scoring_Function score_fxn,
	int cycle_number
);


void
main_chuck_trial(
	int size,
	float & cutoff_max,
	Scoring_Function score_fxn,
	int tag1,
	int tag2
);


void
main_smooth_trial(
	int size,
	float & cutoff,
	Scoring_Function score_fxn,
	int cycle_number
);


void
main_frag_trial(
	int const size,
	Scoring_Function score_fxn,
	int const cycle_number
);

void
main_frag_cst_trial(
	int size,
	Scoring_Function score_fxn,
	int cycle_number,
	float tolerance
);

void
main_double_trial(
	int size,
	float & cutoff_max,
	Scoring_Function score_fxn,
	int & min_spacing,
	int & max_spacing
);


void
main_coupled_phipsi_trial(
	int nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & minimize_type
);


void
main_minimize_trial(
	Scoring_Function score_fxn,
	std::string const & type
);


void
main_frag_min_trial(
	int const size,
	Scoring_Function score_fxn,
	int const cycle_number,
	std::string const & type
);


void
main_double_min_trial(
	int & size,
	float & cutoff_max,
	Scoring_Function score_fxn,
	int & min_space,
	int & max_space,
	std::string const & type
);


void
main_smooth_min_trial(
	int & size,
	float & cutoff,
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_small_wobble_min_trial(
	int const nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int const cycle_number,
	int const nwobble,
	int const max_wobble_gap,
	std::string const & type
);


void
main_small_min_trial(
	int nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_shear_min_trial(
	int nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_wobble_min_trial(
	int size,
	float cutoff_max,
	Scoring_Function score_fxn,
	int cycle_number,
	int nwobble,
	int max_wobble_gap,
	std::string const & type
);


void
main_barcode_min_trial(
	int nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_native_barcode_move(
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_barcode_min_cycle(
	int iteration,
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_feature_small_min_trial(
	int num_in, // how many residue to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_feature_shear_min_trial(
	int num_in, // how many residue to change
	Scoring_Function score_fxn,
	int cycle_number,
	std::string const & type
);


void
main_feature_small_wobble_min_trial(
	int const nmoves, // how many residues to change
	Scoring_Function score_fxn,
	int const cycle_number,
	int const nwobble,
	int const max_wobble_gap,
	std::string const & type
);


void
pose_small_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const int nmoves
);


void
pose_shear_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const int nmoves
);


void
pose_small_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const int nmoves,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix = ""
	);

void
pose_symm_rb_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const float transmag,
	const float rotmag,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix // = ""
);


void
pose_rb_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	std::string const & min_type,
	int const jump_number,
	int const dir,
	float const trans_mag,
	float const rot_mag,
	const bool try_rotamers,
	const float energycut
);


void
pose_shear_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const int nmoves,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix = ""
	);

void
pose_ccd_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	int const loop_begin,
	int const loop_end,
	int const cutpoint,
	int const ccd_cycles,
	const bool try_rotamers,
	const float energycut
	);

void
main_wiggle_junction_min_trial(
	int junction_res, // how many residue to change
	Scoring_Function score_fxn,
	int cycle,
	std::string const & type
);

void
pose_small_wobble_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const int size,
	const int nwobble,
	const int max_wobble_gap,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix // = ""
	);

void
pose_wobble_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const int size,
	const float cutoff_max,
	const int nwobble,
	const int max_wobble_gap,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix // = ""
	);

void
pose_crank_min_trial(
	pose_ns::Pose & pose,
	pose_ns::Monte_carlo & mc,
	const pose_ns::Score_weight_map & weight_map,
	std::string const & min_type,
	const int size,
	const float cutoff_max,
	const int nwobble1,
	const int nwobble2,
	const bool try_rotamers,
	const float energycut,
	std::string const tag_suffix // = ""
	);

#endif
