// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $

#include "trajectory.h"
#include "after_opts.h"
#include "files_paths.h" // for making trajectory
#include "monte_carlo.h"
#include "namespace_trajectory.h"
#include "misc.h"

// Objexx Headers
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Utility headers
#include <utility/basic_sys_util.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <iostream>
#include <string>
#include <vector>

void
clear_trajectory()
{
#ifdef BOINC_GRAPHICS
	static bool init = false;
	if ( ! init ) {
		trajectory::rmsd_vector.reserve(300000);
		trajectory::energy_vector.reserve(300000);
		init = true ;
	}
#endif
  trajectory::rmsd_vector.clear();
  trajectory::energy_vector.clear();
}

void
append_trajectory(float score, float rms_err)
{

	if (rms_err < 0.0) { //signal that something weird happened
	  int const size_so_far = trajectory::rmsd_vector.size();
		if (size_so_far > 0 ) rms_err = trajectory::rmsd_vector[ size_so_far - 1];
	}

  trajectory::rmsd_vector.push_back(rms_err);
  trajectory::energy_vector.push_back(score);
}

void
store_low_info()
{
#ifdef BOINC_GRAPHICS
	static bool init = false;
	if ( ! init ) {
		trajectory::low_rmsd.reserve(30000);
		trajectory::low_energy.reserve(30000);
		init = true ;
	}
#endif
	trajectory::low_rmsd.push_back(mc_global_track::diagnose::low_rms);
	trajectory::low_energy.push_back(mc_global_track::mc_score::low_score);
}

//Movie namespace
namespace traj_data {
	int counter = { 1 };
}
/////////////////////////////////////////////////////////////////////////////
// @begin make_trajectory
//
// @brief  calls the write_xyz function of monte_carlo and then adds additional
// information to the pdb
//
// @detailed
//
// @global_read
//
// @global_write
//
// @remarks
//
// @references
//
// @authors Monica Berrondo
//
// @last_modified September 22 2006
/////////////////////////////////////////////////////////////////////////////
void
make_trajectory(
		std::string const move_type,
		int const mc_accepted,
		int const trial_counter,
		int const accept_counter
		)
{
	using namespace files_paths;
	using namespace traj_data;
	write_xyz();

	static bool make_movie = { false };
	static bool make_trajectory = { false };
	static bool init = { false };

	if ( !init ) {
		init = true;
		make_movie = truefalseoption("movie");
		make_trajectory = truefalseoption("trajectory");
		if ( !make_movie && !make_trajectory ) return;
	}

	if ( !make_movie && !make_trajectory ) return;

	std::string const filename( movie_path + movie_file + lead_zero_string_of( counter, 4 ) + "T.pdb" );
	std::string const status_file ( movie_path + "movie.status" );
	std::string const tmp( movie_path + movie_file + "_tmp.pdb" );

	++counter;

	utility::io::ozstream movie_x( tmp );

	if ( !movie_x ) {
		std::cout << "Open failed for file: " << tmp << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string accepted_type;

	switch( mc_accepted ) {
		case 0:
			accepted_type = "not accepted";
			break;
		case 1:
			accepted_type = "thermally accepted: score worse than best_score";
			break;
		case 2:
			accepted_type = "accepted:score beat best_score";
			break;
		case 3:
			accepted_type = "accepted:score beat low_score and best_score";
			break;
	} // end switch on mc_accepted

	movie_x << "Move type: " << A( 50, move_type ) << '\n';
	movie_x << "Acceptanced type: " << A( 50, accepted_type ) << '\n' ;
	movie_x << "Trials of this move type: " << I( 30, trial_counter ) << '\n';
	movie_x << "Accepts of this move type: " << I( 30, accept_counter ) << '\n';

	movie_x.close();
	movie_x.clear();

	std::string command;
	command = "cat " + tmp + " >> " + filename;
	std::system( command.c_str() );
	command = "rm " + tmp;
	std::system( command.c_str() );

	std::ofstream outfile (status_file.c_str(), std::ios::out|std::ios::app);
	outfile << filename << std::endl;
	outfile << "Move type: " << move_type << std::endl;
	outfile << "Acceptancee type: " << accepted_type << std::endl;
  outfile << "Trials of this move type: " << trial_counter << std::endl;
	outfile << "Accepts of this move type: " << accept_counter << std::endl;
}
