// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13219 $
//  $Date: 2007-03-02 17:03:59 +0200 (Fri, 02 Mar 2007) $
//  $Author: leaverfa $

#ifndef INCLUDED_vdw
#define INCLUDED_vdw
#include <vector>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray3D.hh>

//Rosetta Headers
#include "atom.h"


// vdw Function Declarations



void
vdw_compute( float & vdw_score );

void
ss_vdw( FArray3DB_float const & Eposition,
				int const & MAX_POS,
				int const & i,
				char const & ssi,
				int const & j,
				char const & ssj,
				int const & lEt_1j,
				int const & lEp_11j,
				int const & lEt_1i,
				int const & lEp_11i,
				float & vdw_score_j );

void
accept_best_vdw_bumps();


void
vdw_hetero(
	FArray3DB_float const & Eposition, // positon array for residues
	FArray2DB_float const & centroid,
	FArray1DB_short const & atom_type_cen, // residue type array
	int total_residue, // logical size of Eposition
//	FArray1DB_int const & hetero_atom_cent, // hetero atom centroid types
//	FArray2DB_float const & hetero_atom_coord, // hetero atom coordinates
	std::vector< Atom * > const & ligand,
	int hetero_atom_count, // logical size of Het_position
	FArray2DB_float const & atom_vdw,
	float & vdw_score // adds the hetero score to the input score
);


void
update_cendist(
    int total_residue,
    FArray2D_float centroid
);


void
accept_best_cendist();


void
compute_CB_environment();


void
setup_atom_type();


void
vdw_compute_ij(
	int const i,
	int const j,
	float & vdw_score
);

void
set_default_atomvdw( std::string const & setting );


void
setup_atomvdw();


void
select_atomvdw( std::string const & which );


bool
get_ss_vdw();

int
get_ss_vdw_neighborspacer();

namespace vdw {

	extern std::string atomvdw_set;
	extern FArray2D_float atom_vdw;

namespace initializers {

	void
	atom_vdw_tables_initializer(
	FArray3D_float & atom_vdw_tables
	);

}

namespace constants {

	extern int const default_type;
	extern int const highres;
	extern int const hybrid;

	extern FArray3D_float const atom_vdw_tables;

}

} // vdw

#endif
