// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_void
#define INCLUDED_void

//Rosetta Headers
#include "ligand_ns.h"
#include "RotamerDotsFWD.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// void Function Declarations
void
calc_sasa_pack_score(
	int const total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
);


bool
initialize_sasa_pack_arrays();


float
retrieve_sasa_pack_score();


float
retrieve_sub_sasa_pack_score(
	FArray1Da_bool allow_repack
	);


void
probe_calc_min_rsq(
	FArray2Da_float rsq_min,
	float const radius // input
);


void
calc_sasa_prob();


float
retrieve_rsd_sasa_prob( int const res );


bool
initialize_sasa_prob_arrays();


float
retrieve_avg_sasa_prob();


float
calc_residue_sasa_prob(
	int this_aa,
	float sasa5,
	float sasa14,
	float sasa14_pack_score
);


void
get_res_res_overlap(
  pack::RotamerCoords const & res1,
  pack::RotamerCoords const & res2,
  FArray2DB< ubyte > & res1_covered_by_res2_small,
  FArray2DB< ubyte > & res1_covered_by_res2_large,
  FArray2DB< ubyte > & res2_covered_by_res1_small,
  FArray2DB< ubyte > & res2_covered_by_res1_large,
  FArray1DB_bool & res1_atoms_overlap_at_all,
  FArray1DB_bool & res2_atoms_overlap_at_all
);


void
get_res_res_overlap(
	pack::RotamerCoords const & res1,
	pack::RotamerCoords const & res2,
	FArray2DB< ubyte > & res1_covered_by_res2_small,
	FArray2DB< ubyte > & res1_covered_by_res2_large,
	FArray2DB< ubyte > & res2_covered_by_res1_small,
	FArray2DB< ubyte > & res2_covered_by_res1_large,
	FArray3DB< short > & overlap_masks,
	int num_res2_atoms_to_ignore,
	FArray1DB_bool & res1_atoms_overlap_at_all,
	FArray1DB_bool & res2_atoms_overlap_at_all
);


void
get_residue_ligand_overlap
(
	pack::RotamerCoords const & res,
	FArray2DB< ubyte > & res_covered_by_lig_small,
	FArray2DB< ubyte > & res_covered_by_lig_large,
	FArray1DB_bool & res1_atoms_overlap_at_all,
	Ligand & ligand
);


void
get_residue_self_coverage(
	pack::RotamerCoords const & res,
	FArray2DB< ubyte > & res_self_overlap_small,
	FArray2DB< ubyte > & res_self_overlap_large
);


bool
get_atom_coverage(
	FArray1DB_float const & at1_coord,
	int at1_atomtype,
	FArray1DB_float const & at2_coord,
	int at2_atomtype,
	FArray1Da_ubyte at1_small_sphere_covered,
	FArray1Da_ubyte at1_large_sphere_covered,
	float & square_distance
);


bool
get_2_way_atom_atom_coverage(
  FArray1DB_float const & at1_coord,
  int at1_atomtype,
  FArray1DB_float const & at2_coord,
  int at2_atomtype,
  FArray1Da_ubyte at1_small_sphere_covered,
  FArray1Da_ubyte at2_small_sphere_covered,
  FArray1Da_ubyte at1_large_sphere_covered,
  FArray1Da_ubyte at2_large_sphere_covered,
  float & square_distance
);


bool
get_2_way_atom_atom_coverage(
  FArray1DB_float const & at1_coord,
  int at1_atomtype,
  FArray1DB_float const & at2_coord,
  int at2_atomtype,
  FArray1Da_ubyte at1_small_sphere_covered,
  FArray1Da_ubyte at2_small_sphere_covered,
  FArray1Da_ubyte at1_large_sphere_covered,
  FArray1Da_ubyte at2_large_sphere_covered,
  FArray1Da_short overlap_masks,
  float & square_distance
);


#endif
